<?php 
	/**
	* Plugin Main Class
	*/
	if ( ! defined( 'ABSPATH' ) ) exit;
	class VC_Image_Over_Image_Class
	{
		
		function __construct() 
		{
			add_action('vc_before_init', array($this, 'vc_ioi_settings'));
			add_shortcode( 'image_over_image_vc', array( $this, 'render_image_hover_shortcode' ) );
			add_action( 'wp_enqueue_scripts', array($this, 'loading_ioi_scripts') );
			add_action( 'init', array( $this, 'check_if_vc_is_install' ) );
		}

		function vc_ioi_settings(){
			include 'includes/setting-options.php'; 


			$ihe_main_var = array(
				"name" => __("Image Over Image"),
				"base" => "image_over_image_vc",
				"category" => __('by VCAddons'),
				"description" => __('Add image over image.'),
				"params" => $settings_params
			);

			vc_map($ihe_main_var);
		}
		function loading_ioi_scripts(){
			wp_enqueue_style( 'ioi-font-awesome-css', plugins_url( 'css/font-awesome.min.css' , __FILE__ ));
			wp_enqueue_style( 'ioi-styles-css', plugins_url( 'css/ioi.css' , __FILE__ ));
		}
		function render_image_hover_shortcode($attrs, $content = null){ 
			extract(shortcode_atts( array(
			'ioi_front_image'					=> "",
		    "ioi_back_image"					=> '',
		    "ioi_caption_url"					=> '',
		    "ioi_url_target"					=> '',
		    "ioi_image_effect"					=> '',
			), $attrs));


			if ($ioi_front_image != '') {
				$front_image_url = wp_get_attachment_url( $ioi_front_image );		
			};

			if ($ioi_back_image != '') {
				$back_image_url = wp_get_attachment_url( $ioi_back_image );		
			};
			ob_start(); ?>
		
			<div class="ioi-container">
				<div class="ioi-<?php echo $ioi_image_effect; ?>">
				    <a class="he-box" href="<?php echo $ioi_caption_url; ?>" target="<?php echo $ioi_url_target; ?>">
				        <div class="box-img">
				        	<?php if ($ioi_image_effect == 'style7'): ?>
				        		<span class="he-over-layer">
                                    <img src="<?php echo $back_image_url; ?> " alt="">
                                </span>
				        	<?php endif ?>
				        	<?php if ( $ioi_image_effect == 'style8' ): ?>
				        		<span class="he-over-layer"></span>
				        	<?php endif ?>

				            <img src="<?php echo $front_image_url; ?> " alt="">

				        	<?php if ( $ioi_image_effect == 'style9' ): ?>
				        		<span class="he-over-layer"></span>
				        	<?php endif ?>
				        </div>
				        <div class="he-content">
				            <img src="<?php echo $back_image_url; ?> " alt="">
				        </div>
				    </a>
				</div>
			</div>

			<?php
			return ob_get_clean();
		}

		function check_if_vc_is_install(){
	        if ( ! defined( 'WPB_VC_VERSION' ) ) {
	            // Display notice that Visual Compser is required
	            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
	            return;
		    }
	    }
	    function showVcVersionNotice() {
	        $plugin_name = 'Image Over Image - VC Extension';
	        echo '
	        <div class="updated">
	          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="http://codecanyon.net/item/visual-composer-page-builder-for-wordpress/242431" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'ich-vc'), $plugin_name).'</p>
	        </div>';
	    }

	}

	if (class_exists('WPBakeryShortCodesContainer')) {
	    class image_over_image_vc extends WPBakeryShortCodesContainer {
	    }
	}
 ?>